import tkinter
import random

# konštanty špecifikujúce parametre generovaného obrazu
SIRKA_PLATNA = 500
VYSKA_PLATNA = 500

VELKOST_STVORCA = 10

MAX_CIAR = 10
MIN_CIAR = 6
MAX_OBDLZNIKOV = 10
MIN_OBDLZNIKOV = 3

POCET_RIADKOV = VYSKA_PLATNA // VELKOST_STVORCA
POCET_STLPCOV = SIRKA_PLATNA // VELKOST_STVORCA

FARBY = ['red', 'yellow', 'blue']

def ciary():
    pocet = random.randint(MIN_CIAR, MAX_CIAR)

    for h in range(pocet // 2):
        r = random.randrange(POCET_RIADKOV)
        for s in range(POCET_STLPCOV):
            platno.itemconfig(obraz[r][s], fill='black', tag='ciary')

    for v in range(pocet // 2):
        s = random.randrange(POCET_STLPCOV)
        for r in range(POCET_RIADKOV):
            platno.itemconfig(obraz[r][s], fill='black', tag='ciary')


def mriezka():
    for r in range(POCET_RIADKOV):
        for s in range(POCET_STLPCOV):
            obraz[r][s] = platno.create_rectangle(s * VELKOST_STVORCA, r * VELKOST_STVORCA, (s + 1) * VELKOST_STVORCA,
                                                  (r + 1) * (VELKOST_STVORCA), fill='white', outline='', tag='prazdne')


def obdlzniky():
    pocet = random.randint(MIN_OBDLZNIKOV, MAX_OBDLZNIKOV)
    for i in range(pocet):
        farba = random.choice(FARBY)
        stvorcek = random.choice(prazdne)
        vypln(stvorcek, farba)


def vypln(stvorcek, farba):
    suradnice = platno.coords(stvorcek)
    start_r = int(suradnice[1]) // VELKOST_STVORCA
    start_s = int(suradnice[0]) // VELKOST_STVORCA
    platno.itemconfig(obraz[start_r][start_s], fill='red', tag='vypln')

    # vyhľadanie okrajových riadkových a stĺpcových indexov obdĺžnikovej
    # oblasti, v ktorej tento štvorček leží
    # rh – horný riadok, rd = dolný riadok
    # sl – ľavý stĺpec, sp = pravý stĺpec
    r = start_r
    while r >= 0 and obraz[r][start_s] in prazdne: r -= 1
    rh, r = r + 1, start_r
    while r < POCET_RIADKOV and obraz[r][start_s] in prazdne: r += 1
    rd, s = r - 1, start_s
    while s >= 0 and obraz[start_r][s] in prazdne: s -= 1
    sl, s = s + 1, start_s
    while s < POCET_STLPCOV and obraz[start_r][s] in prazdne: s += 1
    sp = s - 1

    # prefarbenie všetkých švorčekov obdĺžnika
    for r in range(rh, rd + 1):
        for s in range(sl, sp + 1):
            platno.itemconfig(obraz[r][s], fill=farba, tag='vypln')


# hlavný program
# príprava grafického plátna
platno = tkinter.Canvas(width=SIRKA_PLATNA, height=VYSKA_PLATNA, bg='white')

# vytvorenie zoznamu zoznamov pre pamätanie si štvorcov siete
obraz = [[0] * POCET_STLPCOV for i in range(POCET_RIADKOV)]

# vykreslenie štvorcov na plátne
mriezka()
# vykreslenie čiar
ciary()

# funkcia vráti n-ticu všetkých štvorčekov, ktoré majú tento štítok
prazdne = platno.find_withtag('prazdne')

# vyplnenie obdĺžnikov
obdlzniky()

# zobrazenie aplikácie s plátnom
platno.pack()
platno.mainloop()
